Ext.data.JsonP.sol_common_AsUtils({"tagname":"class","name":"sol.common.AsUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.AsUtils.js","href":"lib_sol.common.AsUtils.html#sol-common-AsUtils"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.03.002"],"elojc":true,"eloas":true,"eloix":true,"requires":["sol.common.Config","sol.common.HttpUtils","sol.common.JsonUtils","sol.common.Template","sol.common.WfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.AsUtils","id":"property-logger","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"buildAsUrl","tagname":"method","owner":"sol.common.AsUtils","id":"method-buildAsUrl","meta":{}},{"name":"callAs","tagname":"method","owner":"sol.common.AsUtils","id":"method-callAs","meta":{}},{"name":"checkParams","tagname":"method","owner":"sol.common.AsUtils","id":"method-checkParams","meta":{"private":true}},{"name":"convertAsUrlToConfigObject","tagname":"method","owner":"sol.common.AsUtils","id":"method-convertAsUrlToConfigObject","meta":{}},{"name":"formatErrorMessage","tagname":"method","owner":"sol.common.AsUtils","id":"method-formatErrorMessage","meta":{"private":true}},{"name":"getAsUrl","tagname":"method","owner":"sol.common.AsUtils","id":"method-getAsUrl","meta":{"deprecated":{"text":"<p>Returns the ELOas URL</p>\n"}}},{"name":"guessAsBaseUrl","tagname":"method","owner":"sol.common.AsUtils","id":"method-guessAsBaseUrl","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"obfuscateTicket","tagname":"method","owner":"sol.common.AsUtils","id":"method-obfuscateTicket","meta":{}},{"name":"prepareParam2","tagname":"method","owner":"sol.common.AsUtils","id":"method-prepareParam2","meta":{"private":true}},{"name":"prepareParameter","tagname":"method","owner":"sol.common.AsUtils","id":"method-prepareParameter","meta":{"private":true}},{"name":"prepareUrlParams","tagname":"method","owner":"sol.common.AsUtils","id":"method-prepareUrlParams","meta":{"private":true}},{"name":"testAsBaseUrl","tagname":"method","owner":"sol.common.AsUtils","id":"method-testAsBaseUrl","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.AsUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.AsUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.HttpUtils' rel='sol.common.HttpUtils' class='docClass'>sol.common.HttpUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils' target='_blank'>lib_sol.common.AsUtils.js</a></div></pre><div class='doc-contents'><p>Utilities to interact with the ELO Automation Services</p>\n      <p class='version-tag'>Version: <b>1.03.002</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-property-logger' class='name expandable'>logger</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-buildAsUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-buildAsUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-buildAsUrl' class='name expandable'>buildAsUrl</a>( <span class='pre'>params, addTicket</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Builds an ELOas URL ...</div><div class='long'><p>Builds an ELOas URL</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>solutionNameForAsConfig</span> : String<div class='sub-desc'><p>Solution name for AS config</p>\n</div></li><li><span class='pre'>protocol</span> : String<div class='sub-desc'><p>Protocol</p>\n</div></li><li><span class='pre'>serverName</span> : String<div class='sub-desc'><p>Server name</p>\n</div></li><li><span class='pre'>port</span> : String<div class='sub-desc'><p>Port</p>\n</div></li><li><span class='pre'>serviceName</span> : String<div class='sub-desc'><p>Service name</p>\n</div></li><li><span class='pre'>cmd</span> : String (optional)<div class='sub-desc'><p>Command, e.g. ´run´ or ´get´</p>\n<p>Defaults to: <code>get</code></p></div></li><li><span class='pre'>ruleName</span> : String<div class='sub-desc'><p>Rule name</p>\n</div></li><li><span class='pre'>param1</span> : String<div class='sub-desc'><p>Parameter 1</p>\n</div></li><li><span class='pre'>param2</span> : String<div class='sub-desc'><p>Parameter 2</p>\n</div></li><li><span class='pre'>param2Obj</span> : Object<div class='sub-desc'><p>Parameter object 2</p>\n</div></li><li><span class='pre'>param3</span> : String<div class='sub-desc'><p>Parameter 3</p>\n</div></li><li><span class='pre'>param3Obj</span> : Object<div class='sub-desc'><p>Parameter object 3</p>\n</div></li><li><span class='pre'>ticket</span> : String<div class='sub-desc'><p>Specific ticket</p>\n</div></li></ul></div></li><li><span class='pre'>addTicket</span> : Boolean<div class='sub-desc'><p>If true the session ticket will be added</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>URL</p>\n</div></li></ul></div></div></div><div id='method-callAs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-callAs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-callAs' class='name expandable'>callAs</a>( <span class='pre'>config</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Calls an ELOas rule ...</div><div class='long'><p>Calls an ELOas rule</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>ruleName</span> : String<div class='sub-desc'><p>Rule name</p>\n</div></li><li><span class='pre'>ticket</span> : String<div class='sub-desc'><p>Adds the specified ticket</p>\n</div></li><li><span class='pre'>cmd</span> : String (optional)<div class='sub-desc'><p><code>run</code> for an asynchronous call, <code>get</code> for a synchronous call</p>\n<p>Defaults to: <code>get</code></p></div></li><li><span class='pre'>solutionNameForAsConfig</span> : String (optional)<div class='sub-desc'><p>This will be used to load the ELOas server configuration</p>\n<p>Defaults to: <code>common</code></p></div></li><li><span class='pre'>expectJsonResponse</span> : String (optional)<div class='sub-desc'><p>Expect JSON response</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>addTicket</span> : String (optional)<div class='sub-desc'><p>Adds the user ticket</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>throwException</span> : String (optional)<div class='sub-desc'><p>If <code>true</code> then a exception will be thrown if an error occurs.</p>\n<p>Defaults to: <code>true</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-checkParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-checkParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-checkParams' class='name expandable'>checkParams</a>( <span class='pre'>params</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if all mandatory parameters are set. ...</div><div class='long'><p>Checks, if all mandatory parameters are set. Used by <a href=\"#!/api/sol.common.AsUtils-method-buildAsUrl\" rel=\"sol.common.AsUtils-method-buildAsUrl\" class=\"docClass\">buildAsUrl</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-convertAsUrlToConfigObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-convertAsUrlToConfigObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-convertAsUrlToConfigObject' class='name expandable'>convertAsUrlToConfigObject</a>( <span class='pre'>url</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Converts an ELOas URL to a configuration object. ...</div><div class='long'><p>Converts an ELOas URL to a configuration object.</p>\n\n<pre><code><a href=\"#!/api/sol.common.AsUtils-method-convertAsUrlToConfigObject\" rel=\"sol.common.AsUtils-method-convertAsUrlToConfigObject\" class=\"docClass\">sol.common.AsUtils.convertAsUrlToConfigObject</a>('http://elosrv01:8080/as-archive');\n{\n  protocol: 'http',\n  server: 'elosrv01',\n  port: '8080',\n  name: 'as-archive'\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>ELOas URL</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>ELOas configuration object}</p>\n</div></li></ul></div></div></div><div id='method-formatErrorMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-formatErrorMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-formatErrorMessage' class='name expandable'>formatErrorMessage</a>( <span class='pre'>message, lines, params</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Formats the error message ...</div><div class='long'><p>Formats the error message</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>message</span> : String<div class='sub-desc'><p>Message</p>\n</div></li><li><span class='pre'>lines</span> : Array<div class='sub-desc'><p>Lines</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>format</span> : String (optional)<div class='sub-desc'><p>Format</p>\n<p>Defaults to: <code>JC</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Error message</p>\n</div></li></ul></div></div></div><div id='method-getAsUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-getAsUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-getAsUrl' class='name expandable'>getAsUrl</a>( <span class='pre'>config</span> ) : String<span class=\"signature\"><span class='deprecated' >deprecated</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n        <div class='rounded-box deprecated-box deprecated-tag-box'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>Returns the ELOas URL</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration. The configuration will be send to ELOas via HTTP parameter 'param2'</p>\n<ul><li><span class='pre'>ruleName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>mode</span> : String (optional)<div class='sub-desc'><p>\"run\" for an asynchronous call, \"get\" for a synchronous call</p>\n<p>Defaults to: <code>&quot;get&quot;</code></p></div></li><li><span class='pre'>solutionNameForAsConfig</span> : String (optional)<div class='sub-desc'><p>This will be used to load the ELOas server configuration</p>\n<p>Defaults to: <code>&quot;common&quot;</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Example:</p>\n</div></li></ul></div></div></div><div id='method-guessAsBaseUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-guessAsBaseUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-guessAsBaseUrl' class='name expandable'>guessAsBaseUrl</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the guessed ELOas base URL ...</div><div class='long'><p>Returns the guessed ELOas base URL</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>url. ELOas base URL.</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-obfuscateTicket' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-obfuscateTicket' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-obfuscateTicket' class='name expandable'>obfuscateTicket</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Obfuscate ticket ...</div><div class='long'><p>Obfuscate ticket</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul></div></div></div><div id='method-prepareParam2' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-prepareParam2' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-prepareParam2' class='name expandable'>prepareParam2</a>( <span class='pre'>params</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Prepares param2 with all properties from params (cleaned). ...</div><div class='long'><p>Prepares param2 with all properties from params (cleaned). Used by <a href=\"#!/api/sol.common.AsUtils-method-buildAsUrl\" rel=\"sol.common.AsUtils-method-buildAsUrl\" class=\"docClass\">buildAsUrl</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-prepareParameter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-prepareParameter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-prepareParameter' class='name expandable'>prepareParameter</a>( <span class='pre'>params</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Applies the default values and the ELOas configuration. ...</div><div class='long'><p>Applies the default values and the ELOas configuration. Used by <a href=\"#!/api/sol.common.AsUtils-method-buildAsUrl\" rel=\"sol.common.AsUtils-method-buildAsUrl\" class=\"docClass\">buildAsUrl</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-prepareUrlParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-prepareUrlParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-prepareUrlParams' class='name expandable'>prepareUrlParams</a>( <span class='pre'>params</span> ) : String[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Prepares the additional parameters (param2 - param10). ...</div><div class='long'><p>Prepares the additional parameters (param2 - param10). Used by <a href=\"#!/api/sol.common.AsUtils-method-buildAsUrl\" rel=\"sol.common.AsUtils-method-buildAsUrl\" class=\"docClass\">buildAsUrl</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-testAsBaseUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AsUtils'>sol.common.AsUtils</span><br/><a href='source/lib_sol.common.AsUtils.html#sol-common-AsUtils-method-testAsBaseUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AsUtils-method-testAsBaseUrl' class='name expandable'>testAsBaseUrl</a>( <span class='pre'>url</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Tests a given ELOas URL ...</div><div class='long'><p>Tests a given ELOas URL</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>var testResult = <a href=\"#!/api/sol.common.AsUtils-method-testAsBaseUrl\" rel=\"sol.common.AsUtils-method-testAsBaseUrl\" class=\"docClass\">sol.common.AsUtils.testAsBaseUrl</a>('http://elosrv01:8080/as-archive/');\n    if (testResult.asUrlTestOk) {\n      // valid url\n    }</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>response</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});